#include <dblib.h>
#include <stdafx.h>
#include <params.h>
#include <constants.h>
#include <lev.h>
#include <stdexcept>

#ifdef __cplusplus
extern "C" {
#endif

RETCODE __declspec(dllexport) xp_dist_lev(SRV_PROC *srvproc);

#ifdef __cplusplus
}
#endif

RETCODE __declspec(dllexport) xp_dist_lev(SRV_PROC *srvproc)
{
	RETCODE rc = XP_NOERROR;
	params *p1 = new params();
	params *p2 = new params();
	params *p3 = new params();
	int d = 0;
	int numparams = params::getparamcount(srvproc);
	try
	{
		if (numparams != 3) {
			Dblib::printerror(srvproc, USAGE_LEV);
			rc = XP_ERROR;
		}
		if (rc == XP_NOERROR) {
			params::getparam(srvproc, 1, p1);
			params::getparam(srvproc, 2, p2);
			params::getparam(srvproc, 3, p3);
			if (p1->isoutput || p2->isoutput || !p3->isoutput) {
				Dblib::printerror(srvproc, USAGE_LEV);
				rc = XP_ERROR;
			}
		}
		if (rc == XP_NOERROR) {
			Levenshtein l;
			d = l.GetDistance(p1->cdata, p1->length, p2->cdata, p2->length);
			double m = (p1->length > p2->length) ? p1->length : p2->length;
			if (m == 0.0) {
				d = 0;
			} else {
				d = (int)((1.0 - ((double)d / m)) * 10000.0);
			}

		}
	} catch (std::exception ex) {
		Dblib::printerror(srvproc, ERR_LEV_EXCEPTION);
		rc = XP_ERROR;
	}

	if (rc == XP_NOERROR)
		srv_paramsetoutput(srvproc, 3, (BYTE *)&d, 4, FALSE);
	else
		srv_paramsetoutput(srvproc, 3, (BYTE *)&d, 4, TRUE);
	
	// Now return the number of rows processed
	srv_senddone(srvproc, SRV_DONE_MORE, (DBUSMALLINT)0, (DBINT)0);
	if (p1 != NULL)
		delete p1;
	p1 = NULL;
	if (p2 != NULL)
		delete p2;
	p2 = NULL;
	if (p3 != NULL)
		delete p3;
	p3 = NULL;


	return rc;
}

